/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.access.MovingEntity;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeReference;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.power.VariableIntPower;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.Comparison;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import io.github.apace100.origins.util.Shape;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITag;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class EntityConditions {
    public static void register() {
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("constant"), new SerializableData().add("value", SerializableDataType.BOOLEAN), (data, entity) -> data.getBoolean("value")));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("and"), new SerializableData().add("conditions", SerializableDataType.ENTITY_CONDITIONS), (data, entity) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(entity))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("or"), new SerializableData().add("conditions", SerializableDataType.ENTITY_CONDITIONS), (data, entity) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(entity))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("block_collision"), new SerializableData().add("offset_x", SerializableDataType.FLOAT).add("offset_y", SerializableDataType.FLOAT).add("offset_z", SerializableDataType.FLOAT), (data, entity) -> entity.field_70170_p.func_226666_b_((Entity)entity, entity.func_174813_aQ().func_72317_d((double)data.getFloat("offset_x") * entity.func_174813_aQ().func_216364_b(), (double)data.getFloat("offset_y") * entity.func_174813_aQ().func_216360_c(), (double)data.getFloat("offset_z") * entity.func_174813_aQ().func_216362_d())).findAny().isPresent()));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("brightness"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.func_70013_c(), data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("daytime"), new SerializableData(), (data, entity) -> entity.field_70170_p.func_72820_D() % 24000L < 13000L));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("time_of_day"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.field_70170_p.func_72820_D() % 24000L, data.getInt("compare_to"))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("fall_flying"), new SerializableData(), (data, entity) -> entity.func_184613_cA()));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("exposed_to_sun"), new SerializableData(), (data, entity) -> {
            if (entity.field_70170_p.func_72935_r() && !entity.func_209511_p()) {
                float f = entity.func_70013_c();
                BlockPos blockPos = entity.func_184187_bx() instanceof BoatEntity ? new BlockPos(entity.func_226277_ct_(), (double)Math.round(entity.func_226278_cu_()), entity.func_226281_cx_()).func_177984_a() : new BlockPos(entity.func_226277_ct_(), (double)Math.round(entity.func_226278_cu_()), entity.func_226281_cx_());
                return f > 0.5f && entity.field_70170_p.func_226660_f_(blockPos);
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("in_rain"), new SerializableData(), (data, entity) -> entity.func_209511_p()));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("invisible"), new SerializableData(), (data, entity) -> entity.func_82150_aj()));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("on_fire"), new SerializableData(), (data, entity) -> entity.func_70027_ad()));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("exposed_to_sky"), new SerializableData(), (data, entity) -> {
            BlockPos blockPos = entity.func_184187_bx() instanceof BoatEntity ? new BlockPos(entity.func_226277_ct_(), (double)Math.round(entity.func_226278_cu_()), entity.func_226281_cx_()).func_177984_a() : new BlockPos(entity.func_226277_ct_(), (double)Math.round(entity.func_226278_cu_()), entity.func_226281_cx_());
            return entity.field_70170_p.func_226660_f_(blockPos);
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("sneaking"), new SerializableData(), (data, entity) -> entity.func_225608_bj_()));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("sprinting"), new SerializableData(), (data, entity) -> entity.func_70051_ag()));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("power_active"), new SerializableData().add("power", SerializableDataType.POWER_TYPE), (data, entity) -> ((PowerTypeReference)data.get("power")).isActive((Entity)entity)));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("status_effect"), new SerializableData().add("effect", SerializableDataType.STATUS_EFFECT).add("min_amplifier", SerializableDataType.INT, 0).add("max_amplifier", SerializableDataType.INT, Integer.MAX_VALUE).add("min_duration", SerializableDataType.INT, 0).add("max_duration", SerializableDataType.INT, Integer.MAX_VALUE), (data, entity) -> {
            Effect effect = (Effect)data.get("effect");
            if (effect == null) {
                return false;
            }
            if (entity.func_70644_a(effect)) {
                EffectInstance instance = entity.func_70660_b(effect);
                return instance.func_76459_b() <= data.getInt("max_duration") && instance.func_76459_b() >= data.getInt("min_duration") && instance.func_76458_c() <= data.getInt("max_amplifier") && instance.func_76458_c() >= data.getInt("min_amplifier");
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("submerged_in"), new SerializableData().add("fluid", SerializableDataType.FLUID_TAG), (data, entity) -> entity.func_208600_a((ITag)data.get("fluid"))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("fluid_height"), new SerializableData().add("fluid", SerializableDataType.FLUID_TAG).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.DOUBLE), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.func_233571_b_((ITag)data.get("fluid")), data.getDouble("compare_to"))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("origin"), new SerializableData().add("origin", SerializableDataType.IDENTIFIER).add("layer", SerializableDataType.IDENTIFIER, null), (data, entity) -> {
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)entity);
            ResourceLocation originId = data.getId("origin");
            if (data.isPresent("layer")) {
                ResourceLocation layerId = data.getId("layer");
                OriginLayer layer = OriginLayers.getLayer(layerId);
                if (layer == null) {
                    return false;
                }
                Origin origin = component.getOrigin(layer);
                if (origin != null) {
                    return origin.getIdentifier().equals((Object)originId);
                }
                return false;
            }
            return component.getOrigins().values().stream().anyMatch(o -> o.getIdentifier().equals((Object)originId));
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("power"), new SerializableData().add("power", SerializableDataType.IDENTIFIER), (data, entity) -> {
            try {
                PowerType powerType = PowerTypeRegistry.get(data.getId("power"));
                return ModComponentsArchitectury.getOriginComponent((Entity)entity).hasPower(powerType);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("food_level"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof PlayerEntity) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((PlayerEntity)entity).func_71024_bL().func_75116_a(), data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("saturation_level"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, entity) -> {
            if (entity instanceof PlayerEntity) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((PlayerEntity)entity).func_71024_bL().func_75115_e(), data.getFloat("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("on_block"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION, null), (data, entity) -> entity.func_233570_aj_() && (!data.isPresent("block_condition") || ((ConditionFactory.Instance)data.get("block_condition")).test(new CachedBlockInfo((IWorldReader)entity.field_70170_p, entity.func_233580_cy_().func_177977_b(), true)))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("equipped_item"), new SerializableData().add("equipment_slot", SerializableDataType.EQUIPMENT_SLOT).add("item_condition", SerializableDataType.ITEM_CONDITION), (data, entity) -> ((ConditionFactory.Instance)data.get("item_condition")).test(entity.func_184582_a((EquipmentSlotType)data.get("equipment_slot")))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("attribute"), new SerializableData().add("attribute", SerializableDataType.ATTRIBUTE).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.DOUBLE), (data, entity) -> {
            double attrValue = 0.0;
            ModifiableAttributeInstance attributeInstance = entity.func_110148_a((Attribute)data.get("attribute"));
            if (attributeInstance != null) {
                attrValue = attributeInstance.func_111126_e();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(attrValue, data.getDouble("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("swimming"), new SerializableData(), (data, entity) -> entity.func_203007_ba()));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("resource"), new SerializableData().add("resource", SerializableDataType.POWER_TYPE).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            int resourceValue = 0;
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)entity);
            Object p = component.getPower((PowerType)data.get("resource"));
            if (p instanceof VariableIntPower) {
                resourceValue = ((VariableIntPower)p).getValue();
            } else if (p instanceof CooldownPower) {
                resourceValue = ((CooldownPower)p).getRemainingTicks();
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(resourceValue, data.getInt("compare_to"));
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("air"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.func_70086_ai(), data.getInt("compare_to"))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("in_block"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION), (data, entity) -> ((ConditionFactory.Instance)data.get("block_condition")).test(new CachedBlockInfo((IWorldReader)entity.field_70170_p, entity.func_233580_cy_(), true))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("block_in_radius"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION).add("radius", SerializableDataType.INT).add("shape", SerializableDataType.enumValue(Shape.class), Shape.CUBE).add("compare_to", SerializableDataType.INT, 1).add("comparison", SerializableDataType.COMPARISON, Comparison.GREATER_THAN_OR_EQUAL), (data, entity) -> {
            Predicate blockCondition = (Predicate)data.get("block_condition");
            int stopAt = -1;
            Comparison comparison = (Comparison)((Object)((Object)data.get("comparison")));
            int compareTo = data.getInt("compare_to");
            switch (comparison) {
                case EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: {
                    stopAt = compareTo + 1;
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    stopAt = compareTo;
                }
            }
            int count = 0;
            for (BlockPos pos : Shape.getPositions(entity.func_233580_cy_(), (Shape)((Object)((Object)data.get("shape"))), data.getInt("radius"))) {
                if (blockCondition.test(new CachedBlockInfo((IWorldReader)entity.field_70170_p, pos, true)) && ++count == stopAt) break;
            }
            return comparison.compare(count, compareTo);
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("dimension"), new SerializableData().add("dimension", SerializableDataType.IDENTIFIER), (data, entity) -> entity.field_70170_p.func_234923_W_() == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)data.getId("dimension"))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("xp_levels"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof PlayerEntity) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((PlayerEntity)entity).field_71068_ca, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("xp_points"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof PlayerEntity) {
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((PlayerEntity)entity).field_71067_cb, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("health"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.func_110143_aJ(), data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("relative_health"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.func_110143_aJ() / entity.func_110138_aP(), data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("biome"), new SerializableData().add("biome", SerializableDataType.IDENTIFIER, null).add("biomes", SerializableDataType.IDENTIFIERS, null).add("condition", SerializableDataType.BIOME_CONDITION, null), (data, entity) -> {
            Biome biome = entity.field_70170_p.func_226691_t_(entity.func_233580_cy_());
            ConditionFactory.Instance condition = (ConditionFactory.Instance)data.get("condition");
            if (data.isPresent("biome") || data.isPresent("biomes")) {
                ResourceLocation biomeId = entity.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
                if (data.isPresent("biome") && biomeId.equals((Object)data.getId("biome"))) {
                    return condition == null || condition.test(biome);
                }
                if (data.isPresent("biomes") && ((List)data.get("biomes")).contains(biomeId)) {
                    return condition == null || condition.test(biome);
                }
                return false;
            }
            return condition == null || condition.test(biome);
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("entity_type"), new SerializableData().add("entity_type", SerializableDataType.ENTITY_TYPE), (data, entity) -> entity.func_200600_R() == data.get("entity_type")));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("scoreboard"), new SerializableData().add("objective", SerializableDataType.STRING).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                Scoreboard scoreboard = player.func_96123_co();
                ScoreObjective objective = scoreboard.func_197899_c(data.getString("objective"));
                String playerName = player.func_200200_C_().func_150261_e();
                if (scoreboard.func_178819_b(playerName, objective)) {
                    int value = scoreboard.func_96529_a(playerName, objective).func_96652_c();
                    return ((Comparison)((Object)((Object)data.get("comparison")))).compare(value, data.getInt("compare_to"));
                }
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("command"), new SerializableData().add("command", SerializableDataType.STRING).add("permission_level", SerializableDataType.INT, 4).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, entity) -> {
            MinecraftServer server = entity.field_70170_p.func_73046_m();
            if (server != null) {
                CommandSource source = new CommandSource(ICommandSource.field_213139_a_, entity.func_213303_ch(), entity.func_189653_aC(), entity.field_70170_p instanceof ServerWorld ? (ServerWorld)entity.field_70170_p : null, data.getInt("permission_level"), entity.func_200200_C_().getString(), entity.func_145748_c_(), server, (Entity)entity);
                int output = server.func_195571_aL().func_197059_a(source, data.getString("command"));
                return ((Comparison)((Object)((Object)data.get("comparison")))).compare(output, data.getInt("compare_to"));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("predicate"), new SerializableData().add("predicate", SerializableDataType.IDENTIFIER), (data, entity) -> {
            ILootCondition lootCondition;
            MinecraftServer server = entity.field_70170_p.func_73046_m();
            if (server != null && (lootCondition = server.func_229736_aP_().func_227517_a_((ResourceLocation)data.get("predicate"))) != null) {
                LootContext.Builder lootBuilder = new LootContext.Builder((ServerWorld)entity.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)entity.func_213303_ch()).func_216021_b(LootParameters.field_216281_a, entity);
                return lootCondition.test((Object)lootBuilder.func_216022_a(LootParameterSets.field_227557_c_));
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("fall_distance"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, entity) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(entity.field_70143_R, data.getFloat("compare_to"))));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("collided_horizontally"), new SerializableData(), (data, entity) -> entity.field_70123_F));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("in_block_anywhere"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION).add("comparison", SerializableDataType.COMPARISON, Comparison.GREATER_THAN_OR_EQUAL).add("compare_to", SerializableDataType.INT, 1), (data, entity) -> {
            Predicate blockCondition = (Predicate)data.get("block_condition");
            int stopAt = -1;
            Comparison comparison = (Comparison)((Object)((Object)data.get("comparison")));
            int compareTo = data.getInt("compare_to");
            switch (comparison) {
                case EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: {
                    stopAt = compareTo + 1;
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    stopAt = compareTo;
                }
            }
            int count = 0;
            AxisAlignedBB box = entity.func_174813_aQ();
            BlockPos blockPos = new BlockPos(box.field_72340_a + 0.001, box.field_72338_b + 0.001, box.field_72339_c + 0.001);
            BlockPos blockPos2 = new BlockPos(box.field_72336_d - 0.001, Math.min(box.field_72337_e - 0.001, (double)entity.field_70170_p.func_217301_I()), box.field_72334_f - 0.001);
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int i = blockPos.func_177958_n(); i <= blockPos2.func_177958_n() && count < stopAt; ++i) {
                for (int j = blockPos.func_177956_o(); j <= blockPos2.func_177956_o() && count < stopAt; ++j) {
                    for (int k = blockPos.func_177952_p(); k <= blockPos2.func_177952_p() && count < stopAt; ++k) {
                        mutable.func_181079_c(i, j, k);
                        if (!blockCondition.test(new CachedBlockInfo((IWorldReader)entity.field_70170_p, (BlockPos)mutable, false))) continue;
                        ++count;
                    }
                }
            }
            return comparison.compare(count, compareTo);
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("entity_group"), new SerializableData().add("group", SerializableDataType.ENTITY_GROUP), (data, entity) -> entity.func_70668_bt() == data.get("group")));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("in_tag"), new SerializableData().add("tag", SerializableDataType.ENTITY_TAG), (data, entity) -> ((ITag)data.get("tag")).func_230235_a_((Object)entity.func_200600_R())));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("climbing"), new SerializableData(), (data, entity) -> entity.func_70617_f_()));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("tamed"), new SerializableData(), (data, entity) -> {
            if (entity instanceof TameableEntity) {
                return ((TameableEntity)entity).func_70909_n();
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("using_item"), new SerializableData().add("item_condition", SerializableDataType.ITEM_CONDITION, null), (data, entity) -> {
            if (entity.func_184587_cr()) {
                ConditionFactory.Instance condition = (ConditionFactory.Instance)data.get("item_condition");
                if (condition != null) {
                    Hand activeHand = entity.func_184600_cs();
                    ItemStack handStack = entity.func_184586_b(activeHand);
                    return condition.test(handStack);
                }
                return true;
            }
            return false;
        }));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("moving"), new SerializableData(), (data, entity) -> ((MovingEntity)entity).isMoving()));
        EntityConditions.register(new ConditionFactory<LivingEntity>(Origins.identifier("enchantment"), new SerializableData().add("enchantment", SerializableDataType.ENCHANTMENT).add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT).add("calculation", SerializableDataType.STRING, "sum"), (data, entity) -> {
            String calculation;
            int value = 0;
            Enchantment enchantment = (Enchantment)data.get("enchantment");
            switch (calculation = data.getString("calculation")) {
                case "sum": {
                    for (ItemStack stack : enchantment.func_222181_a(entity).values()) {
                        value += EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack);
                    }
                    break;
                }
                case "max": {
                    value = EnchantmentHelper.func_185284_a((Enchantment)enchantment, (LivingEntity)entity);
                    break;
                }
                default: {
                    Origins.LOGGER.error("Error in \"enchantment\" entity condition, undefined calculation type: \"" + calculation + "\".");
                }
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(value, data.getInt("compare_to"));
        }));
    }

    private static void register(ConditionFactory<LivingEntity> conditionFactory) {
        ModRegistriesArchitectury.ENTITY_CONDITION.registerSupplied(conditionFactory.getSerializerId(), () -> conditionFactory);
    }
}

